﻿<%@ Page Language="c#" CodePage="1200" %>

<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Ksiega" %>

<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<html>
<head>
	<title>Struktura wiekowa należności - dokumenty</title>
	<script runat="server">
	
 
		public class PrintParams : ContextBase
		{
			private Boolean ksiValues = false;


			[Caption("Wartości księgowe")]
			public Boolean KsiValues
			{
				get { return ksiValues; }
				set { ksiValues = value; }
			}


			public PrintParams(Context ctx) :
				base(ctx)
			{
			}
		}


		private PrintParams priParams;

		[Context]
		public PrintParams PriParams
		{
			get { return priParams; }
			set { priParams = value; }
		}
 
 
 
		class Total : IComparable
		{
			public int CompareTo(object obj)
			{
				if (obj == null)
					return 1;
				Total t = obj as Total;
				if (t == null)
					throw new ArgumentException();
				return symbol.CompareTo(t.Symbol);
			}


			readonly string symbol;
			decimal należności;
			decimal zobowiązania;
			decimal należności2;
			decimal zobowiązania2;
			string razem;

			public Total(string symbol)
			{
				this.symbol = symbol;
				razem = "";
			}

			public void Add(decimal należność, decimal zobowiązanie, decimal należność2, decimal zobowiązanie2)
			{
				należności += należność;
				zobowiązania += zobowiązanie;
				należności2 += należność2;
				zobowiązania2 += zobowiązanie2;
			}

			public string Razem
			{
				get { return razem; }
				set { razem = value; }
			}

			public string Symbol
			{ get { return symbol; } }

			public Currency Należności
			{ get { return new Currency(należności, symbol); } }

			public Currency Zobowiązania
			{ get { return new Currency(zobowiązania, symbol); } }

			public Currency Saldo
			{ get { return new Currency(należności - zobowiązania, symbol); } }

			public Currency Należności2
			{ get { return new Currency(należności2, symbol); } }

			public Currency Zobowiązania2
			{ get { return new Currency(zobowiązania2, symbol); } }

			public Currency Saldo2
			{ get { return new Currency(należności2 - zobowiązania2, symbol); } }
		}

		RozrachunkiIdxViewInfoParams pars = null;

		[Soneta.Business.Context(Required = true)]
		public RozrachunkiIdxViewInfoParams Params
		{
			get { return pars; }
			set { pars = value; }
		}

		RozrachunkiIdxViewInfo.InfoWorker worker = new RozrachunkiIdxViewInfo.InfoWorker();
		StanRozliczeniaRozrachunkuWorker srr = new StanRozliczeniaRozrachunkuWorker();
		Hashtable totals = new Hashtable();

		void OnContextLoad(object sender, EventArgs e)
		{
			worker.Params = pars;

			string ss;

			IPodmiotKasowy podmiot = pars.Podmiot;
			if (podmiot == null)
			{
				ss = "Rozrachunki wg dokumentów";

				if (pars.Zakres != ZakresPodmiotów.Razem)
					ss += "|</strong>Zakres: <strong>" + pars.Zakres;
			}
			else
				ss = "Rozrachunki z kontrahentem " + podmiot;

			ss += "|</strong>Indeks: <strong>" + pars.Indeks + "</strong>, Wartość: <strong>" + pars.StanRozrachunku;
			
			if (PriParams.KsiValues)
				ss += "|</strong>Indeks KS: <strong>" + pars.IndeksKS + "</strong>, Wartość KS: <strong>" + pars.StanRozrachunkuKS;

			TypRozDokumentów dokumenty = pars.Dokumenty;
			if (dokumenty != 0)
				ss += "|</strong>Dokumenty: <strong>" + dokumenty;

			RodzajDokumentów rodzaj = pars.Rodzaj;
			if (rodzaj != 0)
				ss += "|</strong>Rodzaj: <strong>" + rodzaj;

			FromTo okres = pars.Okres;
			if (okres != FromTo.All)
				ss += "|</strong>Dokumenty wystawione w okresie: <strong>" + okres;

			ss += "|</strong>Stan rozrachunków na dzień: <strong>" + pars.Aktualny;

			Waluta waluta = pars.Waluta;
			if (waluta != null)
				ss += "|</strong>Waluta: <strong>" + waluta;

			ReportHeader1.Title = ss;

			if (!PriParams.KsiValues)
			{
				Grid1.RowsInRow = 1;

				foreach (GridColumn clm in Grid1.Columns)
					clm.RowSpan = 1;

				zobowiązanie2.Visible = false;
				należność2.Visible = false;
				saldo.Visible = false;
				saldo2.Visible = false;

				Grid2.RowsInRow = 1;

				foreach (GridColumn clm in Grid2.Columns)
					clm.RowSpan = 1;

				clmsNal2.Visible = false;
				clmsSal2.Visible = false;
				clmsZob2.Visible = false;
			}
		}


		private void OnBeforeRow(object sender, RowEventArgs e)
		{
			worker.Rozrachunek = (RozrachunekIdx)e.Row;
			srr.RozrachunekIdx = (RozrachunekIdx)e.Row;

			Currency zob = worker.Zobowiązanie;
			Currency nal = worker.Należność;
			Currency zob2 = PriParams.KsiValues ? worker.ZobowiązanieKsiOpe : Currency.Zero;
			Currency nal2 = PriParams.KsiValues ? worker.NależnośćKsiOpe : Currency.Zero;

			typ.EditValue = worker.Typ;
			zwłoka.EditValue = worker.Zwłoka;
			pozostaje.EditValue = worker.Pozostaje;

			if (srr.ZobowiazanieSign() != 0)
			{
				zobowiązanie.EditValue = zob;
				zobowiązanie2.EditValue = zob2;
			}
			else
			{
				należność.EditValue = nal;
				należność2.EditValue = nal2;
			}

			if (PriParams.KsiValues)
			{
				saldo.EditValue = worker.Saldo;
				saldo2.EditValue = worker.SaldoKsiOpe;
			}

			Currency cy;
			if (zob != Currency.Empty)
				cy = zob;
			else if (nal != Currency.Empty)
				cy = nal;
			else
				return;

			Total t = (Total)totals[cy.Symbol];
			if (t == null)
			{
				t = new Total(cy.Symbol);
				totals.Add(t.Symbol, t);
			}

			t.Add(nal.Value, zob.Value, nal2.Value, zob2.Value);
		}


		private void OnAfterRender(object sender, EventArgs e)
		{
			ArrayList result = new ArrayList(totals.Values);
			if (result.Count == 0)
				result.Add(new Total("PLN"));
			result.Sort();

			((Total)result[0]).Razem = "<b>Razem:</b>";
			Grid2.DataSource = result;
		}

	
	</script>
</head>
<body>
	<form id="StrukturaWiekowaNaleznosciDokumenty" method="post" runat="server">
	<ea:DataContext ID="dc" runat="server" TypeName="Soneta.Business.Row[],Soneta.Business" OnContextLoad="OnContextLoad" Landscape="true" />
	<cc1:ReportHeader ID="ReportHeader1" Title="Rozrachunki" runat="server" DataMember0="Actual" ContextTypeName="Soneta.Business.ActualDate,Soneta.Business" />
	
	<ea:Grid ID="Grid1" runat="server" RowTypeName="Soneta.Kasa.RozrachunekIdx,Soneta.Kasa" OnBeforeRow="OnBeforeRow" OnAfterRender="OnAfterRender" RowsInRow="2"
		GroupData0="Podmiot.Nazwa" GroupLine="{0} ({1})" GroupData1="Podmiot.Kod" Sort="Podmiot.Nazwa,Podmiot.Kod,Data" EncodeHTML="true" ShowGroupSum="True" ShowSum="Never">

		<Columns>
			<ea:GridColumn Width="4" Align="Center" DataMember="#" Caption="Lp." runat="server" RowSpan="2" />
			<ea:GridColumn Width="4" Align="Center" Caption="Typ" ID="typ" NoWrap="True" runat="server" RowSpan="2" />
			<ea:GridColumn Width="11" DataMember="Data" runat="server" RowSpan="2" />
			<ea:GridColumn Width="35" DataMember="Numer" runat="server" RowSpan="2" />
			<ea:GridColumn Width="11" DataMember="Termin" runat="server" Total="Info" RowSpan="2" />
			<ea:GridColumn Width="6" Align="Center" Caption="Zwł." HideZero="True" ID="zwłoka" runat="server" RowSpan="2" />
			<ea:GridColumn Width="6" Align="Center" Caption="Poz." HideZero="True" ID="pozostaje" runat="server" RowSpan="2" />
			<ea:GridColumn Width="17" Align="Right" Caption="Należności" ID="należność" runat="server" Total="Sum" />
			<ea:GridColumn Width="17" Align="Right" Caption="Należności KS" ID="należność2" runat="server" Total="Sum" />
			<ea:GridColumn Width="17" Align="Right" Caption="Zobowiązania" ID="zobowiązanie" runat="server" Total="Sum" />
			<ea:GridColumn Width="17" Align="Right" Caption="Zobowiązania KS" ID="zobowiązanie2" runat="server" Total="Sum" />
			<ea:GridColumn Width="17" Align="Right" Caption="Saldo" ID="saldo" runat="server" Total="Sum" />
			<ea:GridColumn Width="17" Align="Right" Caption="Saldo KS" ID="saldo2" runat="server" Total="Sum" />
			<ea:GridColumn DataMember="Dokument.Opis" Caption="Opis" ID="opis" runat="server" EncodeHTML="true" RowSpan="2" />
		</Columns>
	</ea:Grid>

	<p />
	
	<ea:Grid ID="Grid2" runat="server" RowsInRow="2" >
		<Columns>
			<ea:GridColumn Width="77" DataMember="#" ID="clmsLp" Caption="Podsumowanie wg walut" Format=" " runat="server" RowSpan="2" />
			<ea:GridColumn ID="GridColumn1" Width="17" Align="Right" Caption="Należności" DataMember="Należności" Format="&lt;b&gt;{0}&lt;/b&gt;" runat="server" />
			<ea:GridColumn Width="17" Align="Right" ID="clmsNal2" Caption="Należności KS" DataMember="Należności2" Format="{0}" runat="server" />
			<ea:GridColumn ID="GridColumn2" Width="17" Align="Right" Caption="Zobowiązania" DataMember="Zobowiązania" Format="&lt;b&gt;{0}&lt;/b&gt;" runat="server" />
			<ea:GridColumn Width="17" Align="Right" ID="clmsZob2" Caption="Zobowiązania KS" DataMember="Zobowiązania2" Format="{0}" runat="server" />
			<ea:GridColumn ID="GridColumn3" Width="17" Align="Right" Caption="Saldo" DataMember="Saldo" Format="&lt;b&gt;{0}&lt;/b&gt;" runat="server" />
			<ea:GridColumn Width="17" Align="Right" ID="clmsSal2" Caption="Saldo KS" DataMember="Saldo2" Format="{0}" runat="server" />
		</Columns>
	</ea:Grid>

	<p />
	
	<cc1:ReportFooter ID="ReportFooter1" runat="server">
		<Subtitles>
			<cc1:FooterSubtitle runat="server" SubtitleType="Operator" />
			<cc1:FooterSubtitle runat="server" Caption="Sporządził" SubtitleType="Podpis" />
			<cc1:FooterSubtitle runat="server" Caption="Sprawdził" SubtitleType="Podpis" />
			<cc1:FooterSubtitle runat="server" Caption="Zatwierdził" SubtitleType="Podpis" />
		</Subtitles>
	</cc1:ReportFooter>
	</form>
</body>
</html>

